/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioFieldAssignments;
import filenet.sim.api.VWScenarioList;
import filenet.sim.api.VWScenarioOutputFieldValue;
import filenet.sim.api.VWScenarioOutputFields;
import filenet.sim.api.VWScenarioXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.base.VWString;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public final class VWScenarioOutputField
extends VWScenarioList
implements Serializable,
Comparable {
    private VWScenarioOutputFields m_parent = null;
    private String m_name = null;

    protected VWScenarioOutputField(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) throws VWException {
        if (this.m_parent != null && this.m_parent.hasOutputField(name)) {
            new VWException(new IllegalArgumentException(VWScenarioOutputFields.StrFieldAlreadyExists.toString(name)));
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.m_name = name;
    }

    public VWScenarioOutputFieldValue newValue(String value, String weight) {
        return new VWScenarioOutputFieldValue(value, weight);
    }

    public VWScenarioOutputFieldValue add(String value, String weight) {
        VWScenarioOutputFieldValue outputValue = this.newValue(value, weight);
        this.add(outputValue);
        return outputValue;
    }

    public boolean add(Object value) {
        return super.add((VWScenarioOutputFieldValue)value);
    }

    public void add(int index, Object value) {
        super.add(index, (VWScenarioOutputFieldValue)value);
    }

    public String toString() {
        return this.m_name;
    }

    public int compareTo(Object o) {
        List lst = (List)o;
        int nSize = Math.min(this.size(), lst.size());
        for (int i = 0; i < nSize; ++i) {
            int nCmp = ((Comparable)this.get(i)).compareTo(lst.get(i));
            if (nCmp == 0) continue;
            return nCmp;
        }
        return this.size() - lst.size();
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    protected boolean hasValue(Object value) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            if (!((VWScenarioOutputFieldValue)i.next()).getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    protected void setParent(VWScenarioOutputFields parent) {
        this.m_parent = parent;
    }

    protected void toXML(StringBuffer buffer, String baseIndent) throws VWException {
        String LEVEL_1_INDENT = baseIndent + "\t";
        buffer.append(baseIndent + "<FieldOutput Name=\"" + VWScenarioXMLHandler.toXMLString(this.getName()) + "\">\n");
        for (VWScenarioOutputFieldValue value : this) {
            buffer.append(LEVEL_1_INDENT + "<FieldWeight ");
            buffer.append("Value=\"" + VWScenarioXMLHandler.toXMLString(value.getValue()) + "\" ");
            buffer.append("Weight=\"" + VWScenarioXMLHandler.toXMLString(value.getWeight()) + "\"/>\n");
        }
        buffer.append(baseIndent + "</FieldOutput>\n");
    }

    protected void validate(VWScenarioFieldAssignments fAssignments, int index) throws VWException {
        VWFieldDefinition wfField = null;
        try {
            wfField = fAssignments.getStepSettings().getScenarioWorkflow().getWorkflowDefinition().getField(this.getName());
        }
        catch (VWException ex) {
            VWString theMessage = new VWString("sim.api.VWScenarioOutputField.InvalidField", "Field Assignments Row {0}: Invalid output field ''{1}'':", new Integer(index), this.getName());
            fAssignments.addValidationError(theMessage.toString() + " " + ex.getLocalizedMessage(), index);
            return;
        }
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ((VWScenarioOutputFieldValue)i.next()).validate(fAssignments, index, wfField);
        }
    }
}

